// To parse this JSON data, do
//
//     final myRequestResponseModel = myRequestResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:play_lab/data/model/global/global_meassage.dart';
import 'package:play_lab/data/model/request/request_model.dart';

MyRequestResponseModel myRequestResponseModelFromJson(String str) => MyRequestResponseModel.fromJson(json.decode(str));

String myRequestResponseModelToJson(MyRequestResponseModel data) => json.encode(data.toJson());

class MyRequestResponseModel {
  String? remark;
  String? status;
  Message? message;
  MyRequestResponseModelData? data;

  MyRequestResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory MyRequestResponseModel.fromJson(Map<String, dynamic> json) => MyRequestResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : MyRequestResponseModelData.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class MyRequestResponseModelData {
  String? imagePath;
  DataData? data;

  MyRequestResponseModelData({
    this.imagePath,
    this.data,
  });

  factory MyRequestResponseModelData.fromJson(Map<String, dynamic> json) => MyRequestResponseModelData(
        imagePath: json["image_path"],
        data: json["data"] == null ? null : DataData.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "image_path": imagePath,
        "data": data?.toJson(),
      };
}

class DataData {
  List<RequestItem>? data;
  String? nextPageUrl;

  DataData({
    this.data,
    this.nextPageUrl,
  });

  factory DataData.fromJson(Map<String, dynamic> json) => DataData(
        data: json["data"] == null ? [] : List<RequestItem>.from(json["data"]!.map((x) => RequestItem.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );

  Map<String, dynamic> toJson() => {
        "data": data == null ? [] : List<dynamic>.from(data!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
      };
}
